

Team = inherited("Team", SimEntity)

Network.registerClass(Team)

Team.variables = {
	sync = {"dead"},
	new = {"map", "type", "baseX", "baseY"},
}
Team.structure = {
	sync = {"b"},
	new = {"e", "i", "f", "f"},
}

Team.interpolation = {
	dead = INTERPOLATORS.bool,
}


function Team:new(map, type, x, y)
	local b = instance(self)
	b.map = map
	b.type = type
	b.name = TEAM_TYPES[type].id
	b.ents = {}
	b.pilots = {}
	b.buildings = {}
	b.baseX = x
	b.baseY = y
	b.looseDelay = 0

	map:addTeam(b)
	return b
end

function Team:getStepFrequency()
	return APP.tickTime*30
end

function Team:def()
	return TEAM_TYPES[self.type]
end

function Team:stat(id)
	return self:def()[id]
end

function Team:getName()
	return self.name
end

function Team:remove()
	self.map:removeTeam(self)
end

function Team:getOwner()
	return self
end

function Team:spawnBuildingSet(classRef, num, spacing, x,y, p)
	local px = x - classRef:getWidth()*(num-1)*0.5 - (num-1)*spacing*0.5
	for i = 1,num do
		local py = self.map:getYAt(px,y)
		local build = self.map.sim:create(classRef, self.map, self, px, py)
		px = px + classRef:getWidth() + spacing

		if p then
			self.map.sim:assignEnt(build, "parent", p)
		end

		if i>= num then
			return build
		end
	end
end

function Team:spawnBuildings(x,y)
	local x,y = self.baseX, self.baseY
	self:spawnBuildingSet(StarPort, 3, 500, x, y)

	local p = self:spawnBuildingSet(MissileSilo, 1, 0, x-2400, y)
	self:spawnBuildingSet(Battery, 2, 400, x-2400, y, p)

	local p = self:spawnBuildingSet(MissileSilo, 1, 0, x+2400, y)
	self:spawnBuildingSet(Battery, 2, 400, x+2400, y, p)

	local shieldCoverage = 7800
	local a = self:spawnBuildingSet(ShieldGenerator, 1, 0, x-shieldCoverage*0.5, y)
	local b = self:spawnBuildingSet(ShieldGenerator, 1, 0, x+shieldCoverage*0.5, y)


	self.map.sim:create(Nexus, self.map, self, x, y, 1)
	self.map.sim:create(Nexus, self.map, self, x-1000, y, 2)
	self.map.sim:create(Nexus, self.map, self, x+1000, y, 3)

	self.map.sim:create(Shield, self.map, self, x, y, a:getDistanceTo(b)*0.5)
end

function Team:getShipType()
	if self.name == "mojan" then
		return SHIP_TYPES.creeper
	else
		return SHIP_TYPES.centurion
	end
end

function Team:step(time)
	for index, pilot in pairs(self.pilots) do
		if not pilot.ship then
			local x,y = self:getSpawnLocation()
			if x and y then
				local ship = self.map.sim:create(SpaceShip, self.map, self, x ,y, -math.pi*0.5, 0, 0, 0, SHIP_TYPES[self:stat("shipType")])
				--local ship = self.map.sim:create(SpaceShip, self.map, self, x + 100000, y-5000, 0, 0, 0, 0, SHIP_TYPES.centurion)
				ship.y = ship.y - ship:getRadius()
				self.map.sim:assignEnt(pilot, "ship", ship)

				--for i=1,10 do
				--	self.map.sim:create(Resource, self.map, self.map, x + i*100 -200 ,y-6000, 0, 0, RESOURCE_TYPES.plutonium)
				--end
				--local miss = self.map.sim:create(Missile, self.map, self, x ,y-2500,-math.pi*0.5, 0, 1000,0, MISSILE_TYPES.nuke)
			end
		elseif pilot.ship.health <= 0 then
			if not pilot.respawnDelay then
				pilot.respawnDelay = 3
			else
				pilot.respawnDelay = pilot.respawnDelay - time
				if pilot.respawnDelay <= 0 then
					pilot.respawnDelay = nil
					self.map.sim:assignEnt(pilot, "ship", nil)
				end
			end
		end
	end

	local any = false
	for index, building in pairs(self.buildings) do
		if building:canSpawnShip() then
			any = true
		end
	end

	if not any then
		self.looseDelay = self.looseDelay + time
		if self.looseDelay >= 5 then
			for index, build in pairs(self.buildings) do
				build:remove()
			end
		end
		self.dead = true
	end
end

function Team:getSpawnLocation()
	local pot = {}
	for index, building in pairs(self.buildings) do
		if building:canSpawnShip() then
			table.insert(pot, building)
		end
	end
	if #pot > 0 then
		local pick = pot[math.random(1,#pot)]
		return pick.x + math.randomGaussian()*pick:getWidth()*0.5, pick.y- pick:getHeight()
	end
end


function Team:addPilot(e)
	table.insertUnique(self.pilots, e)
end

function Team:removePilot(e)
	for index, ent in pairs(self.pilots) do
		if ent == e then
			table.remove(self.pilots, index)
			break
		end
	end
end



function Team:addBuilding(e)
	table.insertUnique(self.buildings, e)
end

function Team:removeBuilding(e)
	for index, ent in pairs(self.buildings) do
		if ent == e then
			table.remove(self.buildings, index)
			break
		end
	end
end



function Team:addEnt(e)
	table.insertUnique(self.ents, e)
end

function Team:removeEnt(e)
	for index, ent in pairs(self.ents) do
		if ent == e then
			table.remove(self.ents, index)
			break
		end
	end
end

function Team:renderAt(x,y,scale,angle,a,r,g,b)
end


Pilot = inherited("Pilot", SimEntity)

Network.registerClass(Pilot)

Pilot.variables = {
	sync = {},
	new = {"team", "name", "playerId"},
}
Pilot.structure = {
	sync = {},
	new = {"e", "s", "i"},
}

function Pilot:new(team, name, playerId)
	local b = instance(self)
	b.team = team
	b.name = name
	b.playerId = playerId
	team:addPilot(b)
	return b
end

function Pilot:getName()
	return self.name
end

function Pilot:remove()
	self.team:removePilot(self)
end

function Pilot:step(time)
end

function Pilot:renderAt(x,y,scale,angle,a,r,g,b)
end

function Pilot:setControls(angle, amount, action, alt)
	if self.ship then
		self.ship.desiredAngle = angle
		self.ship.desiredAmount = amount
		self.ship.action = action
		self.ship.alt = alt
	end
end
